// =====================================================================================
// Copyright (c) 2021-2025 Dave Bernazzani (wavemotion-dave)
//
// Copying and distribution of this emulator, its source code and associated
// readme files, with or without modification, are permitted in any medium without
// royalty provided this copyright notice is used and wavemotion-dave (Phoenix-Edition),
// Alekmaul (original port) and Marat Fayzullin (ColEM core) are thanked profusely.
//
// The ColecoDS emulator is offered as-is, without any warranty. Please see readme.md
// =====================================================================================
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fat.h>
#include <sys/stat.h>

#include "printf.h"

#include "colecoDS.h"
#include "Adam.h"
#include "CRC32.h"
#include "cpu/z80/Z80_interface.h"
#include "cpu/z80/ctc.h"
#include "colecomngt.h"
#include "colecogeneric.h"

#ifdef ZEXALL_TEST
static const unsigned char _zexdoc[8704UL + 1] = {
  0xC3, 0x13, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x06, 0x00, 0xF9, 0x11, 0xDA, 0x1D, 0x0E, 0x09, 0xCD, 0xCE, 0x1D, 0x21, 0x3A, 0x01, 0x7E, 0x23, 0xB6, 0xCA, 0x2F, 0x01,
  0x2B, 0xCD, 0xE2, 0x1A, 0xC3, 0x22, 0x01, 0x11, 0xF6, 0x1D, 0x0E, 0x09, 0xCD, 0xCE, 0x1D, 0xC3, 0x00, 0x00, 0xC2, 0x01, 0x22, 0x02, 0x82, 0x02, 0xE2, 0x02, 0x42, 0x03, 0xA2, 0x03, 0x02, 0x04, 0x62, 0x04, 0xC2, 0x04, 0x22, 0x05, 0x82, 0x05,
  0xE2, 0x05, 0x42, 0x06, 0xA2, 0x06, 0x02, 0x07, 0x62, 0x07, 0xC2, 0x07, 0x22, 0x08, 0x82, 0x08, 0xE2, 0x08, 0x42, 0x09, 0xA2, 0x09, 0x02, 0x0A, 0x62, 0x0A, 0xC2, 0x0A, 0x22, 0x0B, 0x82, 0x0B, 0xE2, 0x0B, 0x42, 0x0C, 0xA2, 0x0C, 0x02, 0x0D,
  0x62, 0x0D, 0xC2, 0x0D, 0x22, 0x0E, 0x82, 0x0E, 0xE2, 0x0E, 0x42, 0x0F, 0xA2, 0x0F, 0x02, 0x10, 0x62, 0x10, 0xC2, 0x10, 0x22, 0x11, 0x82, 0x11, 0xE2, 0x11, 0x42, 0x12, 0xA2, 0x12, 0x02, 0x13, 0x62, 0x13, 0xC2, 0x13, 0x22, 0x14, 0x82, 0x14,
  0xE2, 0x14, 0x42, 0x15, 0xA2, 0x15, 0x02, 0x16, 0x62, 0x16, 0xC2, 0x16, 0x22, 0x17, 0x82, 0x17, 0xE2, 0x17, 0x42, 0x18, 0xA2, 0x18, 0x02, 0x19, 0x62, 0x19, 0xC2, 0x19, 0x22, 0x1A, 0x82, 0x1A, 0x00, 0x00, 0xC7, 0xED, 0x42, 0x00, 0x00, 0x2C,
  0x83, 0x88, 0x4F, 0x2B, 0xF2, 0x39, 0xB3, 0x1F, 0x7E, 0x63, 0x15, 0xD3, 0x89, 0x5E, 0x46, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0x00, 0xFF, 0xFF, 0xF8, 0xB4, 0xEA, 0xA9, 0x3C, 0x61, 0x64, 0x63, 0x2C, 0x73, 0x62, 0x63, 0x3E, 0x20, 0x68, 0x6C, 0x2C, 0x3C, 0x62, 0x63, 0x2C, 0x64, 0x65, 0x2C, 0x68,
  0x6C, 0x2C, 0x73, 0x70, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xC7, 0x09, 0x00, 0x00, 0x00, 0xA5, 0xC4, 0xC7, 0xC4, 0x26, 0xD2, 0x50, 0xA0, 0xEA, 0x58, 0x66, 0x85, 0xC6, 0xDE, 0xC9, 0x9B, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0x00, 0xFF, 0xFF, 0x89, 0xFD, 0xB6, 0x35, 0x61, 0x64, 0x64, 0x20, 0x68,
  0x6C, 0x2C, 0x3C, 0x62, 0x63, 0x2C, 0x64, 0x65, 0x2C, 0x68, 0x6C, 0x2C, 0x73, 0x70, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xC7, 0xDD, 0x09, 0x00, 0x00, 0xAC, 0xDD, 0x94, 0xC2, 0x5B, 0x63, 0xD3, 0x33, 0x76,
  0x6A, 0x20, 0xFA, 0x94, 0x68, 0xF5, 0x36, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xD7, 0x00, 0xFF, 0xFF, 0xC1, 0x33, 0x79, 0x0B, 0x61, 0x64, 0x64, 0x20, 0x69, 0x78, 0x2C, 0x3C, 0x62, 0x63, 0x2C, 0x64, 0x65, 0x2C, 0x69, 0x78, 0x2C, 0x73, 0x70, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xC7, 0xFD, 0x09, 0x00, 0x00, 0xC2, 0xC7, 0x07, 0xF4, 0xC1, 0x51, 0x96, 0x3E, 0xF4, 0x0B, 0x0F, 0x51, 0x92, 0x1E, 0xEA, 0x71, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0x00, 0xFF, 0xFF, 0xE8, 0x81, 0x7B, 0x9E, 0x61, 0x64, 0x64, 0x20, 0x69, 0x79, 0x2C, 0x3C, 0x62, 0x63, 0x2C, 0x64, 0x65,
  0x2C, 0x69, 0x79, 0x2C, 0x73, 0x70, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xC6, 0x00, 0x00, 0x00, 0x40, 0x91, 0x3C, 0x7E, 0x67, 0x7A, 0x6D, 0xDF, 0x61, 0x5B, 0x29, 0x0B, 0x10, 0x66, 0xB2, 0x85, 0x38,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x48,
  0x79, 0x93, 0x60, 0x61, 0x6C, 0x75, 0x6F, 0x70, 0x20, 0x61, 0x2C, 0x6E, 0x6E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x80, 0x00, 0x00, 0x00, 0x3E,
  0xC5, 0x3A, 0x57, 0x4D, 0x4C, 0x03, 0x01, 0x09, 0xE3, 0x66, 0xA6, 0xD0, 0x3B, 0xBB, 0xAD, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0x00, 0x00, 0x00, 0xFE, 0x43, 0xB0, 0x16, 0x61, 0x6C, 0x75, 0x6F, 0x70, 0x20, 0x61, 0x2C, 0x3C, 0x62, 0x2C, 0x63, 0x2C, 0x64, 0x2C, 0x65, 0x2C, 0x68, 0x2C, 0x6C, 0x2C,
  0x28, 0x68, 0x6C, 0x29, 0x2C, 0x61, 0x3E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x84, 0x00, 0x00, 0xF7, 0xD6, 0x6E, 0xC7, 0xCF, 0xAC, 0x47, 0x28, 0xDD, 0x22, 0x35, 0xC0, 0xC5, 0x38, 0x4B, 0x23, 0x20, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0x00, 0x00, 0x00, 0xA4, 0x02, 0x6D, 0x5A, 0x61, 0x6C, 0x75, 0x6F, 0x70,
  0x20, 0x61, 0x2C, 0x3C, 0x69, 0x78, 0x68, 0x2C, 0x69, 0x78, 0x6C, 0x2C, 0x69, 0x79, 0x68, 0x2C, 0x69, 0x79, 0x6C, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x86, 0x01, 0x00, 0xB7, 0x90, 0x02, 0x01, 0x02, 0x01, 0xFD, 0x32, 0x6E,
  0x40, 0xDC, 0xC1, 0x45, 0x6E, 0xFA, 0xE5, 0x20, 0x38, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xE8, 0x49, 0x67, 0x6E, 0x61, 0x6C, 0x75, 0x6F, 0x70, 0x20, 0x61, 0x2C, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0x53, 0xDD, 0xCB, 0x01, 0x46, 0x75, 0x20, 0x02, 0x01, 0x02, 0x01, 0xFC, 0x3C, 0x9A, 0xA7, 0x74, 0x3D, 0x51, 0x27, 0x14, 0xCA, 0x20, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xEE, 0x08, 0x67, 0x62, 0x69, 0x74, 0x20, 0x6E, 0x2C, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79,
  0x3E, 0x2B, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0x53, 0xCB, 0x40, 0x00, 0x00, 0xF1, 0x3E, 0xFC, 0x9D, 0xCC, 0x7A, 0x03, 0x01, 0x61, 0xBE, 0x86, 0x7A, 0x50, 0x24, 0x98, 0x19, 0x00,
  0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x7B,
  0x55, 0xE6, 0xC8, 0x62, 0x69, 0x74, 0x20, 0x6E, 0x2C, 0x3C, 0x62, 0x2C, 0x63, 0x2C, 0x64, 0x2C, 0x65, 0x2C, 0x68, 0x2C, 0x6C, 0x2C, 0x28, 0x68, 0x6C, 0x29, 0x2C, 0x61, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0xA9, 0x00, 0x00, 0xB6,
  0xC7, 0xB4, 0x72, 0xF6, 0x18, 0x14, 0x01, 0xBD, 0x8D, 0x01, 0x00, 0xC0, 0x30, 0xA3, 0x94, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xA8, 0x7E, 0x6C, 0xFA, 0x63, 0x70, 0x64, 0x3C, 0x72, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0xA1, 0x00, 0x00, 0x48, 0x4D, 0x4A, 0xAF, 0x6B, 0x90, 0x03, 0x01, 0x71, 0x4E, 0x01, 0x00, 0x93, 0x6A, 0x7C, 0x90, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x06, 0xDE, 0xB3, 0x56, 0x63, 0x70, 0x69, 0x3C, 0x72,
  0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x27, 0x00, 0x00, 0x00, 0x41, 0x21, 0xFA, 0x09, 0x60, 0x1D, 0x59, 0xA5, 0x5B,
  0x8D, 0x79, 0x90, 0x04, 0x8E, 0x9D, 0x29, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9B, 0x4B, 0xA6, 0x75, 0x3C, 0x64, 0x61, 0x61, 0x2C, 0x63, 0x70, 0x6C, 0x2C, 0x73, 0x63, 0x66, 0x2C, 0x63, 0x63, 0x66, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0x3C, 0x00, 0x00, 0x00, 0xDF, 0x4A, 0xD8, 0xD5, 0x98, 0xE5, 0x2B, 0x8A, 0xB0, 0xA7, 0x1B, 0x43, 0x44, 0x5A, 0x30, 0xD0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD1, 0x88, 0x15, 0xA4, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x61, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x04, 0x00, 0x00, 0x00, 0x23, 0xD6, 0x2D, 0x43, 0x61, 0x7A, 0x80, 0x81, 0x86, 0x5A, 0x85, 0x1E, 0x86, 0x58, 0xBB, 0x9B, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x5F,
  0x68, 0x22, 0x64, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x62, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x03, 0x00, 0x00, 0x00, 0x97,
  0xCD, 0xAB, 0x44, 0xC9, 0x8D, 0xE3, 0xE3, 0xCC, 0x11, 0xA4, 0xE8, 0x02, 0x49, 0x4D, 0x2A, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD2, 0xAE, 0x3B, 0xEC, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x62, 0x63, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x0C, 0x00, 0x00, 0x00, 0x89, 0xD7, 0x35, 0x09, 0x5B, 0x05, 0x85, 0x9F, 0x27, 0x8B, 0x08, 0xD2, 0x95, 0x05, 0x60, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xC2, 0x84, 0x55, 0x4C, 0x3C, 0x69, 0x6E, 0x63, 0x2C,
  0x64, 0x65, 0x63, 0x3E, 0x20, 0x63, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x14, 0x00, 0x00, 0x00, 0xEA, 0xA0, 0xBA, 0x5F, 0xFB, 0x65, 0x1C, 0x98, 0xCC,
  0x38, 0xBC, 0xDE, 0x43, 0x5C, 0xBD, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x45, 0x23, 0xDE, 0x10, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x64, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0x13, 0x00, 0x00, 0x00, 0x2E, 0x34, 0x1D, 0x13, 0xC9, 0x28, 0xCA, 0x0A, 0x67, 0x99, 0x2E, 0x3A, 0x92, 0xF6, 0x54, 0x9D, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xAE, 0xC6, 0xD4, 0x2C, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x64, 0x65, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x1C, 0x00, 0x00, 0x00, 0x2F, 0x60, 0x0D, 0x4C, 0x02, 0x24, 0xF5, 0xE2, 0xF4, 0xA0, 0x0A, 0xA1, 0x13, 0x32, 0x25, 0x59, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xE1,
  0x75, 0xAF, 0xCC, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x65, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x24, 0x00, 0x00, 0x00, 0x06,
  0x15, 0xEB, 0xF2, 0xDD, 0xE8, 0x2B, 0x26, 0xA6, 0x11, 0x1A, 0xBC, 0x17, 0x06, 0x18, 0x28, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x1C, 0xED, 0x84, 0x7D, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x68, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x23, 0x00, 0x00, 0x00, 0xF4, 0xC3, 0xA5, 0x07, 0x6D, 0x1B, 0x04, 0x4F, 0xC2, 0xE2, 0x2A, 0x82, 0x57, 0xE0, 0xE1, 0xC3, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xFC, 0x0D, 0x6D, 0x4A, 0x3C, 0x69, 0x6E, 0x63, 0x2C,
  0x64, 0x65, 0x63, 0x3E, 0x20, 0x68, 0x6C, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x23, 0x00, 0x00, 0x3C, 0xBC, 0x9B, 0x0D, 0x81, 0xE0, 0xFD, 0xAD, 0x7F,
  0x9A, 0xE5, 0x96, 0x13, 0x85, 0xE2, 0x0B, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xA5, 0x4D, 0xBE, 0x31, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x69, 0x78, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0xFD, 0x23, 0x00, 0x00, 0x02, 0x94, 0x7A, 0x63, 0x82, 0x31, 0x5A, 0xC6, 0xE9, 0xB2, 0xB4, 0xAB, 0x16, 0xF2, 0x05, 0x6D, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x50, 0x5D, 0x51, 0xA3, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x69, 0x79, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x2C, 0x00, 0x00, 0x00, 0x31, 0x80, 0x20, 0xA5, 0x56, 0x43, 0x09, 0xB4, 0xC1, 0xF4, 0xA2, 0xDF, 0xD1, 0x3C, 0xA2, 0x3E, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x56,
  0xCD, 0x06, 0xF3, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x6C, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x34, 0x00, 0x00, 0x00, 0x56,
  0xB8, 0x7C, 0x0C, 0x3E, 0xE5, 0x03, 0x01, 0x7E, 0x87, 0x58, 0xDA, 0x15, 0x5C, 0x37, 0x1F, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xDC, 0xEF, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x28, 0x68, 0x6C, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x33, 0x00, 0x00, 0x00, 0x6F, 0x34, 0x82, 0xD4, 0x69, 0xD1, 0xB6, 0xDE, 0x94, 0xA4, 0x76, 0xF4, 0x53, 0x02, 0x5B, 0x85, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x5D, 0xAC, 0xD5, 0x27, 0x3C, 0x69, 0x6E, 0x63, 0x2C,
  0x64, 0x65, 0x63, 0x3E, 0x20, 0x73, 0x70, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x34, 0x01, 0x00, 0x6E, 0xFA, 0x02, 0x01, 0x02, 0x01, 0x28, 0x2C, 0x94,
  0x88, 0x57, 0x50, 0x16, 0x33, 0x6F, 0x28, 0x20, 0x01, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x20, 0x58, 0x14, 0x70, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0xDD, 0x24, 0x00, 0x00, 0x38, 0xB8, 0x6C, 0x31, 0xD4, 0xC6, 0x01, 0x3E, 0x58, 0x83, 0xB4, 0x15, 0x81, 0xDE, 0x59, 0x42, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x6F, 0x46, 0x36, 0x62, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x69, 0x78, 0x68,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x2C, 0x00, 0x00, 0x14, 0x4D, 0x60, 0x74, 0xD4, 0x76, 0xE7, 0x06, 0xA2, 0x32, 0x3C, 0x21, 0xD6, 0xD7, 0xA5, 0x99, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x02,
  0x7B, 0xEF, 0x2C, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x69, 0x78, 0x6C, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x24, 0x00, 0x00, 0x36,
  0x28, 0x6F, 0x9F, 0x16, 0x91, 0xB9, 0x61, 0xCB, 0x82, 0x19, 0xE2, 0x92, 0x73, 0x8C, 0xA9, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x2D, 0x96, 0x6C, 0xF3, 0x3C, 0x69, 0x6E, 0x63, 0x2C, 0x64, 0x65, 0x63, 0x3E, 0x20, 0x69, 0x79, 0x68, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x2C, 0x00, 0x00, 0xC6, 0xD7, 0xD5, 0x62, 0x9E, 0xA0, 0x39, 0x70, 0x7E, 0x3E, 0x12, 0x9F, 0x90, 0xD9, 0x0F, 0x22, 0x00, 0x01, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xFB, 0xCB, 0xBA, 0x95, 0x3C, 0x69, 0x6E, 0x63, 0x2C,
  0x64, 0x65, 0x63, 0x3E, 0x20, 0x69, 0x79, 0x6C, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0x4B, 0x03, 0x01, 0xA8, 0xF9, 0x59, 0xF5, 0xA4, 0x93, 0xED, 0xF5, 0x96,
  0x6F, 0x68, 0xD9, 0x86, 0xE6, 0xD8, 0x4B, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4D, 0x45, 0xA9, 0xAC, 0x6C, 0x64, 0x20, 0x3C, 0x62, 0x63, 0x2C, 0x64, 0x65, 0x3E, 0x2C, 0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0x2A, 0x03, 0x01, 0x00, 0x63, 0x98, 0x30, 0x78, 0x77, 0x20, 0xFE, 0xB1, 0xFA, 0xB9, 0xB8, 0xAB, 0x04, 0x06, 0x15, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x97, 0x24, 0x87, 0x6C, 0x64, 0x20, 0x68, 0x6C, 0x2C, 0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0x7B, 0x03, 0x01, 0xFC, 0x8D, 0xD7, 0x57, 0x61, 0x21, 0x18, 0xCA, 0x85, 0xC1, 0xDA, 0x27, 0x83, 0x1E, 0x60, 0xF4, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7A,
  0xCE, 0xA1, 0x1B, 0x6C, 0x64, 0x20, 0x73, 0x70, 0x2C, 0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x2A, 0x03, 0x01, 0xD7,
  0xDE, 0xFA, 0xA6, 0x80, 0xF7, 0x4C, 0x24, 0xDE, 0x87, 0xC2, 0xBC, 0x16, 0x63, 0x96, 0x4C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0x8B, 0xF1, 0x6D, 0x6C, 0x64, 0x20, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2C, 0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0x43, 0x03, 0x01, 0x98, 0x1F, 0x4D, 0x84, 0xAC, 0xE8, 0xED, 0xC9, 0x5D, 0xC9, 0x61, 0x8F, 0x80, 0x3F, 0xBF, 0xC7, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x64, 0x1E, 0x87, 0x15, 0x6C, 0x64, 0x20, 0x28, 0x6E,
  0x6E, 0x6E, 0x6E, 0x29, 0x2C, 0x3C, 0x62, 0x63, 0x2C, 0x64, 0x65, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x22, 0x03, 0x01, 0x00, 0x03, 0xD0, 0x72, 0x77, 0x53, 0x7F, 0x72, 0x3F, 0xEA,
  0x64, 0x80, 0xE1, 0x10, 0x2D, 0xE9, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA3, 0x60, 0x8B, 0x47, 0x6C, 0x64, 0x20, 0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x2C, 0x68, 0x6C, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0xED, 0x73, 0x03, 0x01, 0xDC, 0xC0, 0xD6, 0xD1, 0x5A, 0xED, 0x56, 0xF3, 0xDA, 0xAF, 0xA7, 0x6C, 0x44, 0x9F, 0x0A, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x16, 0x58, 0x5F, 0xD7, 0x6C, 0x64, 0x20, 0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x2C, 0x73, 0x70, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x22, 0x03, 0x01, 0xC3, 0x6C, 0x91, 0x0D, 0x00, 0x69, 0xF8, 0x8E, 0xD6, 0xE3, 0xF7, 0xC3, 0xC6, 0xD9, 0xDF, 0xC2, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBA,
  0x10, 0x2A, 0x6B, 0x6C, 0x64, 0x20, 0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x2C, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x01, 0x00, 0x00, 0x00, 0x1C,
  0x5C, 0x46, 0x2D, 0xB9, 0x8E, 0x78, 0x60, 0xB1, 0x74, 0x0E, 0xB3, 0x46, 0xD1, 0xCC, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDE, 0x39, 0x19, 0x69, 0x6C, 0x64, 0x20, 0x3C, 0x62, 0x63, 0x2C, 0x64, 0x65, 0x2C, 0x68, 0x6C, 0x2C, 0x73, 0x70, 0x3E, 0x2C, 0x6E, 0x6E, 0x6E, 0x6E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x21, 0x00, 0x00, 0xE8, 0x87, 0x06, 0x20, 0x12, 0xBD, 0x9B, 0xB6, 0x53, 0x72, 0xE5, 0xA1, 0x51, 0x13, 0xBD, 0xF1, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x7D, 0xD5, 0x25, 0x6C, 0x64, 0x20, 0x3C, 0x69,
  0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2C, 0x6E, 0x6E, 0x6E, 0x6E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x0A, 0x00, 0x00, 0x00, 0xA8, 0xB3, 0x2A, 0x1D, 0x8E, 0x7F, 0xAC, 0x42, 0x03,
  0x01, 0x03, 0x01, 0xC6, 0xB1, 0x8E, 0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0xFF, 0x00, 0x00, 0xB0, 0x81, 0x89, 0x35, 0x6C, 0x64, 0x20, 0x61, 0x2C, 0x3C, 0x28, 0x62, 0x63, 0x29, 0x2C, 0x28, 0x64, 0x65, 0x29, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0x06, 0x00, 0x00, 0x00, 0x07, 0xC4, 0x9D, 0xF4, 0x3D, 0xD1, 0x39, 0x03, 0x89, 0xDE, 0x55, 0x74, 0x53, 0xC0, 0x09, 0x55, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF1, 0xDA, 0xB5, 0x56, 0x6C, 0x64, 0x20, 0x3C, 0x62, 0x2C, 0x63, 0x2C, 0x64, 0x2C, 0x65, 0x2C, 0x68,
  0x2C, 0x6C, 0x2C, 0x28, 0x68, 0x6C, 0x29, 0x2C, 0x61, 0x3E, 0x2C, 0x6E, 0x6E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x36, 0x01, 0x00, 0x45, 0x1B, 0x02, 0x01, 0x02, 0x01, 0xC1, 0xD5, 0xC7, 0x61, 0xC4, 0xBD, 0xC0, 0x85, 0x16, 0xCD, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x26,
  0xDB, 0x47, 0x7E, 0x6C, 0x64, 0x20, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2C, 0x6E, 0x6E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x46, 0x01, 0x00, 0x16,
  0xD0, 0x02, 0x01, 0x02, 0x01, 0x60, 0x42, 0x39, 0x7F, 0x04, 0x04, 0x97, 0x4A, 0x85, 0xD0, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0x11, 0x06, 0xA8, 0x6C, 0x64, 0x20, 0x3C, 0x62, 0x2C, 0x63, 0x2C, 0x64, 0x2C, 0x65, 0x3E, 0x2C, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E,
  0x2B, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x66, 0x01, 0x00, 0xE0, 0x84, 0x02, 0x01, 0x02, 0x01, 0x52, 0x9C, 0x99, 0xA7, 0xB6, 0x49, 0x93, 0x00, 0xAD, 0xEE, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFA, 0x2A, 0x4D, 0x03, 0x6C, 0x64, 0x20, 0x3C, 0x68,
  0x2C, 0x6C, 0x3E, 0x2C, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x7E, 0x01, 0x00, 0xB6, 0xD8, 0x02, 0x01, 0x02, 0x01, 0x12, 0xC6, 0x07,
  0xDF, 0xD0, 0x9C, 0x43, 0xA6, 0xE5, 0xA0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA5, 0xE9, 0xAC, 0x64, 0x6C, 0x64, 0x20, 0x61, 0x2C, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0xDD, 0x26, 0x00, 0x00, 0x53, 0x3C, 0x40, 0x46, 0x79, 0xE1, 0x11, 0x77, 0x07, 0xC1, 0xFA, 0x1A, 0x81, 0xAD, 0x9B, 0x5D, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x24, 0xE8, 0x82, 0x8B, 0x6C, 0x64, 0x20, 0x3C, 0x69, 0x78, 0x68, 0x2C, 0x69, 0x78, 0x6C, 0x2C, 0x69,
  0x79, 0x68, 0x2C, 0x69, 0x79, 0x6C, 0x3E, 0x2C, 0x6E, 0x6E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x40, 0x00, 0x00, 0x00, 0xA4, 0x72, 0x24, 0xA0, 0xAC, 0x61, 0x03, 0x01, 0xC7, 0x82, 0x8F, 0x71, 0x97, 0x8F, 0x8E, 0xEF, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0xFF, 0x00, 0x00, 0x74,
  0x4B, 0x01, 0x18, 0x6C, 0x64, 0x20, 0x3C, 0x62, 0x63, 0x64, 0x65, 0x68, 0x6C, 0x61, 0x3E, 0x2C, 0x3C, 0x62, 0x63, 0x64, 0x65, 0x68, 0x6C, 0x61, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x40, 0x00, 0x00, 0xC5,
  0xBC, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0xC2, 0x2F, 0xC0, 0x98, 0x83, 0x1F, 0xCD, 0x3B, 0x20, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0xFF, 0x00, 0x00, 0x47, 0x8B, 0xA3, 0x6B, 0x6C, 0x64, 0x20, 0x3C, 0x62, 0x63, 0x64, 0x65, 0x78, 0x79, 0x61, 0x3E, 0x2C, 0x3C, 0x62, 0x63, 0x64, 0x65, 0x78, 0x79, 0x61,
  0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x32, 0x03, 0x01, 0x00, 0x68, 0xFD, 0xEC, 0xF4, 0xA0, 0x44, 0x43, 0xB5, 0x53, 0x06, 0xBA, 0xCD, 0xD2, 0x4F, 0xD8, 0x1F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0xFF, 0x00, 0x00, 0xC9, 0x26, 0x2D, 0xE5, 0x6C, 0x64, 0x20, 0x61, 0x2C,
  0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x20, 0x2F, 0x20, 0x6C, 0x64, 0x20, 0x28, 0x6E, 0x6E, 0x6E, 0x6E, 0x29, 0x2C, 0x61, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0xA8, 0x00, 0x00, 0x52, 0x98, 0xFA, 0x68, 0xA1, 0x66, 0x06, 0x01, 0x04,
  0x01, 0x01, 0x00, 0xC1, 0x68, 0xB7, 0x20, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x94, 0xF4, 0x27, 0x69, 0x6C, 0x64, 0x64, 0x3C, 0x72, 0x3E, 0x20, 0x28, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0xED, 0xA8, 0x00, 0x00, 0x2E, 0xF1, 0x2A, 0xEB, 0xBA, 0xD5, 0x06, 0x01, 0x04, 0x01, 0x02, 0x00, 0x47, 0xFF, 0xE4, 0xFB, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x5A, 0x90, 0x7E, 0xD4, 0x6C, 0x64, 0x64, 0x3C, 0x72, 0x3E, 0x20, 0x28, 0x32, 0x29, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0xA0, 0x00, 0x00, 0x30, 0xFE, 0xCD, 0x03, 0x58, 0x60, 0x05, 0x01, 0x03, 0x01, 0x01, 0x00, 0x04, 0x60, 0x88, 0x26, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x9A,
  0xBD, 0xF6, 0xB5, 0x6C, 0x64, 0x69, 0x3C, 0x72, 0x3E, 0x20, 0x28, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0xA0, 0x00, 0x00, 0xCE,
  0x4A, 0x6E, 0xC2, 0x88, 0xB1, 0x05, 0x01, 0x03, 0x01, 0x02, 0x00, 0x14, 0x2D, 0x9F, 0xA3, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xEB, 0x59, 0x89, 0x1B, 0x6C, 0x64, 0x69, 0x3C, 0x72, 0x3E, 0x20, 0x28, 0x32, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0x44, 0x00, 0x00, 0xA2, 0x38, 0x6B, 0x5F, 0x34, 0xD9, 0xE4, 0x57, 0xD6, 0xD2, 0x42, 0x46, 0x43, 0x5A, 0xCC, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6A, 0x3C, 0x3B, 0xBD, 0x6E, 0x65, 0x67, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xED, 0x67, 0x00, 0x00, 0xCB, 0x91, 0x8B, 0xC4, 0x62, 0xFA, 0x03, 0x01, 0x20,
  0xE7, 0x79, 0xB4, 0x40, 0x06, 0xE2, 0x8A, 0x00, 0x08, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0xFF, 0x00, 0x00, 0x95, 0x5B, 0xA3, 0x26, 0x3C, 0x72, 0x72, 0x64, 0x2C, 0x72, 0x6C, 0x64, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0x07, 0x00, 0x00, 0x00, 0x92, 0xCB, 0x43, 0x6D, 0x90, 0x0A, 0x84, 0xC2, 0x53, 0x0C, 0x0E, 0xF5, 0x91, 0xEB, 0xFC, 0x40, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x25, 0x13, 0x30, 0xAE, 0x3C, 0x72, 0x6C, 0x63, 0x61, 0x2C, 0x72, 0x72, 0x63, 0x61, 0x2C, 0x72, 0x6C,
  0x61, 0x2C, 0x72, 0x72, 0x61, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0xCB, 0x01, 0x06, 0xAF, 0xDD, 0x02, 0x01, 0x02, 0x01, 0x3C, 0xFF, 0xF6, 0xDB, 0xF4, 0x94, 0x82, 0x80, 0xD9, 0x61, 0x20,
  0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x71,
  0x3A, 0xCD, 0x81, 0x73, 0x68, 0x66, 0x2F, 0x72, 0x6F, 0x74, 0x20, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xCB, 0x00, 0x00, 0x00, 0xEB,
  0xCC, 0x4A, 0x5D, 0x07, 0xE0, 0x03, 0x01, 0x95, 0x13, 0xEE, 0x30, 0x43, 0x78, 0xAD, 0x3D, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xFF, 0x00, 0x00, 0xEB, 0x60, 0x4D, 0x58, 0x73, 0x68, 0x66, 0x2F, 0x72, 0x6F, 0x74, 0x20, 0x3C, 0x62, 0x2C, 0x63, 0x2C, 0x64, 0x2C, 0x65, 0x2C, 0x68, 0x2C, 0x6C, 0x2C,
  0x28, 0x68, 0x6C, 0x29, 0x2C, 0x61, 0x3E, 0x2E, 0x2E, 0x24, 0xD7, 0xCB, 0x80, 0x00, 0x00, 0xD5, 0x2C, 0xAB, 0x97, 0xFF, 0x39, 0x03, 0x01, 0x4B, 0xD1, 0xB2, 0x6A, 0x53, 0x27, 0x38, 0xB5, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0xFF, 0x00, 0x00, 0x8B, 0x57, 0xF0, 0x08, 0x3C, 0x73, 0x65, 0x74, 0x2C,
  0x72, 0x65, 0x73, 0x3E, 0x20, 0x6E, 0x2C, 0x3C, 0x62, 0x63, 0x64, 0x65, 0x68, 0x6C, 0x28, 0x68, 0x6C, 0x29, 0x61, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0xCB, 0x01, 0x86, 0x44, 0xFB, 0x02, 0x01, 0x02, 0x01, 0x09, 0xBA, 0xBE,
  0x68, 0xD8, 0x32, 0x10, 0x5E, 0x67, 0xA8, 0x20, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xCC, 0x63, 0xF9, 0x8A, 0x3C, 0x73, 0x65, 0x74, 0x2C, 0x72, 0x65, 0x73, 0x3E, 0x20, 0x6E, 0x2C, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x24, 0xD7, 0xDD, 0x70, 0x01, 0x00, 0x0D, 0x27, 0x02, 0x01, 0x02, 0x01, 0x3A, 0xB7, 0x7B, 0x88, 0xEE, 0x99, 0x86, 0x70, 0x07, 0xCA, 0x20, 0x03, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x04, 0x62, 0x6A, 0xBF, 0x6C, 0x64, 0x20, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31,
  0x29, 0x2C, 0x3C, 0x62, 0x2C, 0x63, 0x2C, 0x64, 0x2C, 0x65, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x74, 0x01, 0x00, 0x64, 0xB6, 0x02, 0x01, 0x02, 0x01, 0xAC, 0xE8, 0xF5, 0xB5, 0xFE, 0xAA, 0x12, 0x10, 0x66, 0x95, 0x20,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6A,
  0x1A, 0x88, 0x31, 0x6C, 0x64, 0x20, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2C, 0x3C, 0x68, 0x2C, 0x6C, 0x3E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0xDD, 0x77, 0x01, 0x00, 0xAF,
  0x67, 0x02, 0x01, 0x02, 0x01, 0x13, 0x4F, 0x44, 0x06, 0xD7, 0xBC, 0x50, 0xAC, 0xAF, 0x5F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xCC, 0xBE, 0x5A, 0x96, 0x6C, 0x64, 0x20, 0x28, 0x3C, 0x69, 0x78, 0x2C, 0x69, 0x79, 0x3E, 0x2B, 0x31, 0x29, 0x2C, 0x61, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xD7, 0x02, 0x00, 0x00, 0x00, 0x3B, 0x0C, 0x92, 0xB5, 0xFF, 0x6C, 0x9E, 0x95, 0x03, 0x01, 0x04, 0x01, 0xC1, 0x21, 0xE7, 0xBD, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x7A, 0x4C, 0x11, 0x4F, 0x6C, 0x64, 0x20, 0x28, 0x3C,
  0x62, 0x63, 0x2C, 0x64, 0x65, 0x3E, 0x29, 0x2C, 0x61, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x24, 0xE5, 0x7E, 0x23, 0x66, 0x6F, 0x7E, 0x32, 0x65, 0x1D, 0x23, 0xE5, 0x11, 0x14, 0x00,
  0x19, 0x11, 0xDA, 0x1C, 0xCD, 0x49, 0x1C, 0xE1, 0xE5, 0x11, 0x28, 0x00, 0x19, 0x11, 0x02, 0x1D, 0xCD, 0x49, 0x1C, 0x21, 0x02, 0x1D, 0x36, 0x01, 0xE1, 0xE5, 0x11, 0x42, 0x1D, 0x01, 0x04, 0x00, 0xED, 0xB0, 0x11, 0x03, 0x01, 0x01, 0x10, 0x00,
  0xED, 0xB0, 0x11, 0x2C, 0x00, 0x19, 0xEB, 0x0E, 0x09, 0xCD, 0xCE, 0x1D, 0xCD, 0x71, 0x1E, 0x3A, 0x42, 0x1D, 0xFE, 0x76, 0xCA, 0x3E, 0x1B, 0xE6, 0xDF, 0xFE, 0xDD, 0xC2, 0x3B, 0x1B, 0x3A, 0x43, 0x1D, 0xFE, 0x76, 0xC4, 0x2A, 0x1D, 0xCD, 0x89,
  0x1C, 0xC4, 0xAD, 0x1C, 0xE1, 0xCA, 0x7A, 0x1B, 0x11, 0x3C, 0x00, 0x19, 0xCD, 0x32, 0x1E, 0x11, 0x05, 0x1E, 0xCA, 0x71, 0x1B, 0x11, 0x0C, 0x1E, 0x0E, 0x09, 0xCD, 0xCE, 0x1D, 0xCD, 0x99, 0x1D, 0x11, 0x27, 0x1E, 0x0E, 0x09, 0xCD, 0xCE, 0x1D,
  0x21, 0x85, 0x1E, 0xCD, 0x99, 0x1D, 0x11, 0x2F, 0x1E, 0x0E, 0x09, 0xCD, 0xCE, 0x1D, 0xE1, 0x23, 0x23, 0xC9, 0xE5, 0x3E, 0x01, 0x32, 0xF0, 0x1B, 0x32, 0x14, 0x1C, 0x21, 0xDA, 0x1C, 0x22, 0xF1, 0x1B, 0x21, 0x02, 0x1D, 0x22, 0x15, 0x1C, 0x06,
  0x04, 0xE1, 0xE5, 0x11, 0x42, 0x1D, 0xCD, 0xA4, 0x1B, 0x06, 0x10, 0x11, 0x03, 0x01, 0xCD, 0xA4, 0x1B, 0xC3, 0x27, 0x1B, 0xCD, 0xAD, 0x1B, 0x23, 0x05, 0xC2, 0xA4, 0x1B, 0xC9, 0xC5, 0xD5, 0xE5, 0x4E, 0x11, 0x14, 0x00, 0x19, 0x7E, 0xFE, 0x00,
  0xCA, 0xCE, 0x1B, 0x06, 0x08, 0x0F, 0xF5, 0x3E, 0x00, 0xDC, 0xF3, 0x1B, 0xA9, 0x0F, 0x4F, 0xF1, 0x05, 0xC2, 0xBD, 0x1B, 0x06, 0x08, 0x11, 0x14, 0x00, 0x19, 0x7E, 0xFE, 0x00, 0xCA, 0xE9, 0x1B, 0x06, 0x08, 0x0F, 0xF5, 0x3E, 0x00, 0xDC, 0x17,
  0x1C, 0xA9, 0x0F, 0x4F, 0xF1, 0x05, 0xC2, 0xDA, 0x1B, 0xE1, 0xD1, 0x79, 0x12, 0x13, 0xC1, 0xC9, 0x00, 0x00, 0x00, 0xC5, 0xE5, 0x2A, 0xF1, 0x1B, 0x46, 0x21, 0xF0, 0x1B, 0x7E, 0x4F, 0x07, 0x77, 0xFE, 0x01, 0xC2, 0x0C, 0x1C, 0x2A, 0xF1, 0x1B,
  0x23, 0x22, 0xF1, 0x1B, 0x78, 0xA1, 0xE1, 0xC1, 0xC8, 0x3E, 0x01, 0xC9, 0x00, 0x00, 0x00, 0xC5, 0xE5, 0x2A, 0x15, 0x1C, 0x46, 0x21, 0x14, 0x1C, 0x7E, 0x4F, 0x07, 0x77, 0xFE, 0x01, 0xC2, 0x30, 0x1C, 0x2A, 0x15, 0x1C, 0x23, 0x22, 0x15, 0x1C,
  0x78, 0xA1, 0xE1, 0xC1, 0xC8, 0x3E, 0x01, 0xC9, 0xF5, 0xC5, 0xD5, 0xE5, 0x36, 0x00, 0x54, 0x5D, 0x13, 0x0B, 0xED, 0xB0, 0xE1, 0xD1, 0xC1, 0xF1, 0xC9, 0xD5, 0xEB, 0x01, 0x28, 0x00, 0xCD, 0x38, 0x1C, 0xEB, 0x06, 0x14, 0x0E, 0x01, 0x16, 0x00,
  0x5E, 0x7B, 0xA1, 0xCA, 0x5F, 0x1C, 0x14, 0x79, 0x07, 0x4F, 0xFE, 0x01, 0xC2, 0x59, 0x1C, 0x23, 0x05, 0xC2, 0x58, 0x1C, 0x7A, 0xE6, 0xF8, 0x0F, 0x0F, 0x0F, 0x6F, 0x26, 0x00, 0x7A, 0xE6, 0x07, 0x3C, 0x47, 0x3E, 0x80, 0x07, 0x05, 0xC2, 0x7C,
  0x1C, 0xD1, 0x19, 0x11, 0x14, 0x00, 0x19, 0x77, 0xC9, 0xC5, 0xD5, 0xE5, 0x21, 0xDA, 0x1C, 0x11, 0x14, 0x00, 0xEB, 0x19, 0xEB, 0x34, 0x7E, 0xFE, 0x00, 0xCA, 0xA8, 0x1C, 0x47, 0x1A, 0xA0, 0xCA, 0xA4, 0x1C, 0x36, 0x00, 0xC1, 0xD1, 0xE1, 0xC9,
  0x23, 0x13, 0xC3, 0x95, 0x1C, 0xC5, 0xD5, 0xE5, 0x21, 0x02, 0x1D, 0x11, 0x14, 0x00, 0xEB, 0x19, 0xEB, 0x7E, 0xB7, 0xCA, 0xD5, 0x1C, 0x47, 0x1A, 0xA0, 0xC2, 0xD1, 0x1C, 0x78, 0x07, 0xFE, 0x01, 0xC2, 0xCF, 0x1C, 0x36, 0x00, 0x23, 0x13, 0x77,
  0xAF, 0xE1, 0xD1, 0xC1, 0xC9, 0x23, 0x13, 0xC3, 0xB9, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5, 0xC5, 0xD5, 0xE5, 0xF3, 0xED, 0x73, 0x8D, 0x1D, 0x31, 0x05, 0x01, 0xFD, 0xE1, 0xDD, 0xE1, 0xE1, 0xD1, 0xC1, 0xF1, 0xED, 0x7B, 0x11, 0x01, 0x00, 0x00, 0x00, 0x00, 0xED, 0x73,
  0x8B, 0x1D, 0x31, 0x8B, 0x1D, 0xF5, 0xC5, 0xD5, 0xE5, 0xDD, 0xE5, 0xFD, 0xE5, 0xED, 0x7B, 0x8D, 0x1D, 0xFB, 0x2A, 0x03, 0x01, 0x22, 0x7D, 0x1D, 0x21, 0x89, 0x1D, 0x7E, 0xE6, 0xD7, 0x77, 0x06, 0x10, 0x11, 0x7D, 0x1D, 0x21, 0x85, 0x1E, 0x1A,
  0x13, 0xCD, 0x49, 0x1E, 0x05, 0xC2, 0x6F, 0x1D, 0xE1, 0xD1, 0xC1, 0xF1, 0xC9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xCD, 0xAB, 0x1D, 0x23, 0x05, 0xC2, 0x8F, 0x1D,
  0xC9, 0xF5, 0xC5, 0xE5, 0x06, 0x04, 0x7E, 0xCD, 0xAB, 0x1D, 0x23, 0x05, 0xC2, 0x9E, 0x1D, 0xE1, 0xC1, 0xF1, 0xC9, 0xF5, 0x0F, 0x0F, 0x0F, 0x0F, 0xCD, 0xB4, 0x1D, 0xF1, 0xF5, 0xC5, 0xD5, 0xE5, 0xE6, 0x0F, 0xFE, 0x0A, 0xDA, 0xC1, 0x1D, 0xC6,
  0x27, 0xC6, 0x30, 0x5F, 0x0E, 0x02, 0xCD, 0xCE, 0x1D, 0xE1, 0xD1, 0xC1, 0xF1, 0xC9, 0xF5, 0xC5, 0xD5, 0xE5, 0xCD, 0x05, 0x00, 0xE1, 0xD1, 0xC1, 0xF1, 0xC9, 0x5A, 0x38, 0x30, 0x20, 0x69, 0x6E, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6F,
  0x6E, 0x20, 0x65, 0x78, 0x65, 0x72, 0x63, 0x69, 0x73, 0x65, 0x72, 0x0A, 0x0D, 0x24, 0x54, 0x65, 0x73, 0x74, 0x73, 0x20, 0x63, 0x6F, 0x6D, 0x70, 0x6C, 0x65, 0x74, 0x65, 0x24, 0x20, 0x20, 0x4F, 0x4B, 0x0A, 0x0D, 0x24, 0x20, 0x20, 0x45, 0x52,
  0x52, 0x4F, 0x52, 0x20, 0x2A, 0x2A, 0x2A, 0x2A, 0x20, 0x63, 0x72, 0x63, 0x20, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x3A, 0x24, 0x20, 0x66, 0x6F, 0x75, 0x6E, 0x64, 0x3A, 0x24, 0x0A, 0x0D, 0x24, 0xC5, 0xD5, 0xE5, 0x11, 0x85, 0x1E,
  0x06, 0x04, 0x1A, 0xBE, 0xC2, 0x45, 0x1E, 0x23, 0x13, 0x05, 0xC2, 0x3A, 0x1E, 0xE1, 0xD1, 0xC1, 0xC9, 0xF5, 0xC5, 0xD5, 0xE5, 0xE5, 0x11, 0x03, 0x00, 0x19, 0xAE, 0x6F, 0x26, 0x00, 0x29, 0x29, 0xEB, 0x21, 0x89, 0x1E, 0x19, 0xEB, 0xE1, 0x01,
  0x04, 0x00, 0x1A, 0xA8, 0x46, 0x77, 0x13, 0x23, 0x0D, 0xC2, 0x62, 0x1E, 0xE1, 0xD1, 0xC1, 0xF1, 0xC9, 0xF5, 0xC5, 0xE5, 0x21, 0x85, 0x1E, 0x3E, 0xFF, 0x06, 0x04, 0x77, 0x23, 0x05, 0xC2, 0x7B, 0x1E, 0xE1, 0xC1, 0xF1, 0xC9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x07, 0x30, 0x96, 0xEE, 0x0E, 0x61, 0x2C, 0x99, 0x09, 0x51, 0xBA, 0x07, 0x6D, 0xC4, 0x19, 0x70, 0x6A, 0xF4, 0x8F, 0xE9, 0x63, 0xA5, 0x35, 0x9E, 0x64, 0x95, 0xA3, 0x0E, 0xDB, 0x88, 0x32, 0x79, 0xDC, 0xB8,
  0xA4, 0xE0, 0xD5, 0xE9, 0x1E, 0x97, 0xD2, 0xD9, 0x88, 0x09, 0xB6, 0x4C, 0x2B, 0x7E, 0xB1, 0x7C, 0xBD, 0xE7, 0xB8, 0x2D, 0x07, 0x90, 0xBF, 0x1D, 0x91, 0x1D, 0xB7, 0x10, 0x64, 0x6A, 0xB0, 0x20, 0xF2, 0xF3, 0xB9, 0x71, 0x48, 0x84, 0xBE, 0x41,
  0xDE, 0x1A, 0xDA, 0xD4, 0x7D, 0x6D, 0xDD, 0xE4, 0xEB, 0xF4, 0xD4, 0xB5, 0x51, 0x83, 0xD3, 0x85, 0xC7, 0x13, 0x6C, 0x98, 0x56, 0x64, 0x6B, 0xA8, 0xC0, 0xFD, 0x62, 0xF9, 0x7A, 0x8A, 0x65, 0xC9, 0xEC, 0x14, 0x01, 0x5C, 0x4F, 0x63, 0x06, 0x6C,
  0xD9, 0xFA, 0x0F, 0x3D, 0x63, 0x8D, 0x08, 0x0D, 0xF5, 0x3B, 0x6E, 0x20, 0xC8, 0x4C, 0x69, 0x10, 0x5E, 0xD5, 0x60, 0x41, 0xE4, 0xA2, 0x67, 0x71, 0x72, 0x3C, 0x03, 0xE4, 0xD1, 0x4B, 0x04, 0xD4, 0x47, 0xD2, 0x0D, 0x85, 0xFD, 0xA5, 0x0A, 0xB5,
  0x6B, 0x35, 0xB5, 0xA8, 0xFA, 0x42, 0xB2, 0x98, 0x6C, 0xDB, 0xBB, 0xC9, 0xD6, 0xAC, 0xBC, 0xF9, 0x40, 0x32, 0xD8, 0x6C, 0xE3, 0x45, 0xDF, 0x5C, 0x75, 0xDC, 0xD6, 0x0D, 0xCF, 0xAB, 0xD1, 0x3D, 0x59, 0x26, 0xD9, 0x30, 0xAC, 0x51, 0xDE, 0x00,
  0x3A, 0xC8, 0xD7, 0x51, 0x80, 0xBF, 0xD0, 0x61, 0x16, 0x21, 0xB4, 0xF4, 0xB5, 0x56, 0xB3, 0xC4, 0x23, 0xCF, 0xBA, 0x95, 0x99, 0xB8, 0xBD, 0xA5, 0x0F, 0x28, 0x02, 0xB8, 0x9E, 0x5F, 0x05, 0x88, 0x08, 0xC6, 0x0C, 0xD9, 0xB2, 0xB1, 0x0B, 0xE9,
  0x24, 0x2F, 0x6F, 0x7C, 0x87, 0x58, 0x68, 0x4C, 0x11, 0xC1, 0x61, 0x1D, 0xAB, 0xB6, 0x66, 0x2D, 0x3D, 0x76, 0xDC, 0x41, 0x90, 0x01, 0xDB, 0x71, 0x06, 0x98, 0xD2, 0x20, 0xBC, 0xEF, 0xD5, 0x10, 0x2A, 0x71, 0xB1, 0x85, 0x89, 0x06, 0xB6, 0xB5,
  0x1F, 0x9F, 0xBF, 0xE4, 0xA5, 0xE8, 0xB8, 0xD4, 0x33, 0x78, 0x07, 0xC9, 0xA2, 0x0F, 0x00, 0xF9, 0x34, 0x96, 0x09, 0xA8, 0x8E, 0xE1, 0x0E, 0x98, 0x18, 0x7F, 0x6A, 0x0D, 0xBB, 0x08, 0x6D, 0x3D, 0x2D, 0x91, 0x64, 0x6C, 0x97, 0xE6, 0x63, 0x5C,
  0x01, 0x6B, 0x6B, 0x51, 0xF4, 0x1C, 0x6C, 0x61, 0x62, 0x85, 0x65, 0x30, 0xD8, 0xF2, 0x62, 0x00, 0x4E, 0x6C, 0x06, 0x95, 0xED, 0x1B, 0x01, 0xA5, 0x7B, 0x82, 0x08, 0xF4, 0xC1, 0xF5, 0x0F, 0xC4, 0x57, 0x65, 0xB0, 0xD9, 0xC6, 0x12, 0xB7, 0xE9,
  0x50, 0x8B, 0xBE, 0xB8, 0xEA, 0xFC, 0xB9, 0x88, 0x7C, 0x62, 0xDD, 0x1D, 0xDF, 0x15, 0xDA, 0x2D, 0x49, 0x8C, 0xD3, 0x7C, 0xF3, 0xFB, 0xD4, 0x4C, 0x65, 0x4D, 0xB2, 0x61, 0x58, 0x3A, 0xB5, 0x51, 0xCE, 0xA3, 0xBC, 0x00, 0x74, 0xD4, 0xBB, 0x30,
  0xE2, 0x4A, 0xDF, 0xA5, 0x41, 0x3D, 0xD8, 0x95, 0xD7, 0xA4, 0xD1, 0xC4, 0x6D, 0xD3, 0xD6, 0xF4, 0xFB, 0x43, 0x69, 0xE9, 0x6A, 0x34, 0x6E, 0xD9, 0xFC, 0xAD, 0x67, 0x88, 0x46, 0xDA, 0x60, 0xB8, 0xD0, 0x44, 0x04, 0x2D, 0x73, 0x33, 0x03, 0x1D,
  0xE5, 0xAA, 0x0A, 0x4C, 0x5F, 0xDD, 0x0D, 0x7C, 0xC9, 0x50, 0x05, 0x71, 0x3C, 0x27, 0x02, 0x41, 0xAA, 0xBE, 0x0B, 0x10, 0x10, 0xC9, 0x0C, 0x20, 0x86, 0x57, 0x68, 0xB5, 0x25, 0x20, 0x6F, 0x85, 0xB3, 0xB9, 0x66, 0xD4, 0x09, 0xCE, 0x61, 0xE4,
  0x9F, 0x5E, 0xDE, 0xF9, 0x0E, 0x29, 0xD9, 0xC9, 0x98, 0xB0, 0xD0, 0x98, 0x22, 0xC7, 0xD7, 0xA8, 0xB4, 0x59, 0xB3, 0x3D, 0x17, 0x2E, 0xB4, 0x0D, 0x81, 0xB7, 0xBD, 0x5C, 0x3B, 0xC0, 0xBA, 0x6C, 0xAD, 0xED, 0xB8, 0x83, 0x20, 0x9A, 0xBF, 0xB3,
  0xB6, 0x03, 0xB6, 0xE2, 0x0C, 0x74, 0xB1, 0xD2, 0x9A, 0xEA, 0xD5, 0x47, 0x39, 0x9D, 0xD2, 0x77, 0xAF, 0x04, 0xDB, 0x26, 0x15, 0x73, 0xDC, 0x16, 0x83, 0xE3, 0x63, 0x0B, 0x12, 0x94, 0x64, 0x3B, 0x84, 0x0D, 0x6D, 0x6A, 0x3E, 0x7A, 0x6A, 0x5A,
  0xA8, 0xE4, 0x0E, 0xCF, 0x0B, 0x93, 0x09, 0xFF, 0x9D, 0x0A, 0x00, 0xAE, 0x27, 0x7D, 0x07, 0x9E, 0xB1, 0xF0, 0x0F, 0x93, 0x44, 0x87, 0x08, 0xA3, 0xD2, 0x1E, 0x01, 0xF2, 0x68, 0x69, 0x06, 0xC2, 0xFE, 0xF7, 0x62, 0x57, 0x5D, 0x80, 0x65, 0x67,
  0xCB, 0x19, 0x6C, 0x36, 0x71, 0x6E, 0x6B, 0x06, 0xE7, 0xFE, 0xD4, 0x1B, 0x76, 0x89, 0xD3, 0x2B, 0xE0, 0x10, 0xDA, 0x7A, 0x5A, 0x67, 0xDD, 0x4A, 0xCC, 0xF9, 0xB9, 0xDF, 0x6F, 0x8E, 0xBE, 0xEF, 0xF9, 0x17, 0xB7, 0xBE, 0x43, 0x60, 0xB0, 0x8E,
  0xD5, 0xD6, 0xD6, 0xA3, 0xE8, 0xA1, 0xD1, 0x93, 0x7E, 0x38, 0xD8, 0xC2, 0xC4, 0x4F, 0xDF, 0xF2, 0x52, 0xD1, 0xBB, 0x67, 0xF1, 0xA6, 0xBC, 0x57, 0x67, 0x3F, 0xB5, 0x06, 0xDD, 0x48, 0xB2, 0x36, 0x4B, 0xD8, 0x0D, 0x2B, 0xDA, 0xAF, 0x0A, 0x1B,
  0x4C, 0x36, 0x03, 0x4A, 0xF6, 0x41, 0x04, 0x7A, 0x60, 0xDF, 0x60, 0xEF, 0xC3, 0xA8, 0x67, 0xDF, 0x55, 0x31, 0x6E, 0x8E, 0xEF, 0x46, 0x69, 0xBE, 0x79, 0xCB, 0x61, 0xB3, 0x8C, 0xBC, 0x66, 0x83, 0x1A, 0x25, 0x6F, 0xD2, 0xA0, 0x52, 0x68, 0xE2,
  0x36, 0xCC, 0x0C, 0x77, 0x95, 0xBB, 0x0B, 0x47, 0x03, 0x22, 0x02, 0x16, 0xB9, 0x55, 0x05, 0x26, 0x2F, 0xC5, 0xBA, 0x3B, 0xBE, 0xB2, 0xBD, 0x0B, 0x28, 0x2B, 0xB4, 0x5A, 0x92, 0x5C, 0xB3, 0x6A, 0x04, 0xC2, 0xD7, 0xFF, 0xA7, 0xB5, 0xD0, 0xCF,
  0x31, 0x2C, 0xD9, 0x9E, 0x8B, 0x5B, 0xDE, 0xAE, 0x1D, 0x9B, 0x64, 0xC2, 0xB0, 0xEC, 0x63, 0xF2, 0x26, 0x75, 0x6A, 0xA3, 0x9C, 0x02, 0x6D, 0x93, 0x0A, 0x9C, 0x09, 0x06, 0xA9, 0xEB, 0x0E, 0x36, 0x3F, 0x72, 0x07, 0x67, 0x85, 0x05, 0x00, 0x57,
  0x13, 0x95, 0xBF, 0x4A, 0x82, 0xE2, 0xB8, 0x7A, 0x14, 0x7B, 0xB1, 0x2B, 0xAE, 0x0C, 0xB6, 0x1B, 0x38, 0x92, 0xD2, 0x8E, 0x9B, 0xE5, 0xD5, 0xBE, 0x0D, 0x7C, 0xDC, 0xEF, 0xB7, 0x0B, 0xDB, 0xDF, 0x21, 0x86, 0xD3, 0xD2, 0xD4, 0xF1, 0xD4, 0xE2,
  0x42, 0x68, 0xDD, 0xB3, 0xF8, 0x1F, 0xDA, 0x83, 0x6E, 0x81, 0xBE, 0x16, 0xCD, 0xF6, 0xB9, 0x26, 0x5B, 0x6F, 0xB0, 0x77, 0xE1, 0x18, 0xB7, 0x47, 0x77, 0x88, 0x08, 0x5A, 0xE6, 0xFF, 0x0F, 0x6A, 0x70, 0x66, 0x06, 0x3B, 0xCA, 0x11, 0x01, 0x0B,
  0x5C, 0x8F, 0x65, 0x9E, 0xFF, 0xF8, 0x62, 0xAE, 0x69, 0x61, 0x6B, 0xFF, 0xD3, 0x16, 0x6C, 0xCF, 0x45, 0xA0, 0x0A, 0xE2, 0x78, 0xD7, 0x0D, 0xD2, 0xEE, 0x4E, 0x04, 0x83, 0x54, 0x39, 0x03, 0xB3, 0xC2, 0xA7, 0x67, 0x26, 0x61, 0xD0, 0x60, 0x16,
  0xF7, 0x49, 0x69, 0x47, 0x4D, 0x3E, 0x6E, 0x77, 0xDB, 0xAE, 0xD1, 0x6A, 0x4A, 0xD9, 0xD6, 0x5A, 0xDC, 0x40, 0xDF, 0x0B, 0x66, 0x37, 0xD8, 0x3B, 0xF0, 0xA9, 0xBC, 0xAE, 0x53, 0xDE, 0xBB, 0x9E, 0xC5, 0x47, 0xB2, 0xCF, 0x7F, 0x30, 0xB5, 0xFF,
  0xE9, 0xBD, 0xBD, 0xF2, 0x1C, 0xCA, 0xBA, 0xC2, 0x8A, 0x53, 0xB3, 0x93, 0x30, 0x24, 0xB4, 0xA3, 0xA6, 0xBA, 0xD0, 0x36, 0x05, 0xCD, 0xD7, 0x06, 0x93, 0x54, 0xDE, 0x57, 0x29, 0x23, 0xD9, 0x67, 0xBF, 0xB3, 0x66, 0x7A, 0x2E, 0xC4, 0x61, 0x4A,
  0xB8, 0x5D, 0x68, 0x1B, 0x02, 0x2A, 0x6F, 0x2B, 0x94, 0xB4, 0x0B, 0xBE, 0x37, 0xC3, 0x0C, 0x8E, 0xA1, 0x5A, 0x05, 0xDF, 0x1B, 0x2D, 0x02, 0xEF, 0x8D, 0xCD, 0x2B, 0xC9, 0xCD, 0xA8, 0x3D, 0xC3, 0xEF, 0x3C, 0xDD, 0xCB, 0x28, 0xC6, 0x12, 0x13,
  0x7E, 0x23, 0x12, 0x13, 0xFE, 0x0D, 0x28, 0x10, 0xFE, 0x27, 0x20, 0xF4, 0xEB, 0xCD, 0xC0, 0x39, 0xEB, 0xDD, 0xCB, 0x28, 0x46, 0xC8, 0x18, 0xE8, 0x2B, 0x1B, 0xC9, 0xE1, 0xD1, 0x1B, 0x1A, 0xFE, 0x26, 0x28, 0x01, 0x13, 0xD5, 0xE9, 0x0E, 0x01,
  0xDD, 0x46, 0x14, 0x2A, 0x35, 0x41, 0x1A, 0xFE, 0x0D, 0x28, 0x21, 0xCD, 0x3F, 0x3C, 0x28, 0x0F, 0xBE, 0x20, 0x0C, 0x2B, 0x1B, 0x10, 0xEF, 0x1A, 0xCD, 0x3F, 0x3C, 0x20, 0x02, 0xB7, 0xC9, 0x1A, 0x1B, 0xFE, 0x0D, 0x28, 0x07, 0xFE, 0x2C, 0x20,
  0xF6, 0x0C, 0x18, 0xD4, 0x37, 0xC9, 0x3A, 0x3F, 0x41, 0xB7, 0x28, 0x29, 0x47, 0xED, 0x5B, 0x3B, 0x41, 0x21, 0x4E, 0x42, 0x3A, 0xAD, 0x15, 0xB7, 0x00
};


void zextest(void)
{
    MemoryMap[0] = RAM_Memory + 0x0000;
    MemoryMap[1] = RAM_Memory + 0x2000;
    MemoryMap[2] = RAM_Memory + 0x4000;
    MemoryMap[3] = RAM_Memory + 0x6000;
    
    MemoryMap[4] = RAM_Memory + 0x8000;
    MemoryMap[5] = RAM_Memory + 0xA000;
    MemoryMap[6] = RAM_Memory + 0xC000;
    MemoryMap[7] = RAM_Memory + 0xE000;

    memcpy(RAM_Memory+0x000, BIOS_Memory, 0x100);
    memcpy(RAM_Memory+0x100, _zexdoc, sizeof(_zexdoc));
    CPU.PC.W = 0x100;
    CPU.SP.W = 0xF000;
}

void zextrap(void)
{
    if (CPU.PC.W == 0x0005)
    {
        if (CPU.BC.B.l == 2)
        {
            debug_printf("%c", CPU.DE.B.h);
        }
        else if (CPU.BC.B.l == 9)
        {
            u8 *ptr = RAM_Memory + CPU.DE.W;
            while (*ptr != '$') debug_printf("%c", *ptr++);
        }
        CPU.PC.B.l=RAM_Memory[CPU.SP.W++];CPU.PC.B.h=RAM_Memory[CPU.SP.W++];
    }
}

#endif

/*************************** End of file ****************************/
